#ifndef MEDIAFACEIMAGE_H
#define MEDIAFACEIMAGE_H
#include "XSDKPublic.h"
#include "XNetSDKSyn.h"
#include "XNetSDKDefine.h"
#include "VidesData.h"
#include "Common.h"
#include "TaskRunnable.h"
#include <memory>
#include <map>
#include <QDebug>
#include <QThreadPool>
#include <opencv2/opencv.hpp>
class CameraHandle;
class MediaFaceImage
{
public:
    static MediaFaceImage* getInstance();  // 单例模式获取实例的静态成员函数

    void ParserImageData(const unsigned char* pData, int nDataLen, char* pJpg, int* nJpgLen, char* pJson);
    int FaceImageCallBack(XSDK_HANDLE hMedia,int nChannel,cv::Mat &image);
    int CameraImage(XSDK_HANDLE hMedia,int nChannel,std::vector<uchar> &buffer);

    int ToFile(const char* pFileName, const void* pData, int nLenght);

    int AbFile(const char* pFileName, const void* pData, int nLenght);

    int SdkSearchDevicesSyn(std::map< QString,vides_data::localDeviceStatus*>& devices);

    int SdkInit(QString &szConfigPath, QString &szTempPath);

    std::map<int,CameraHandle*>getCurrentDevice();

    void clearCurrentDevice(int hObject);

    void setMap(int &key,CameraHandle*value);
private:
    MediaFaceImage();  // 构造函数声明为私有
    ~MediaFaceImage();  // 析构函数声明为私有

    std::map<int,CameraHandle*>currentDevice;
    static MediaFaceImage* m_instance;  // 指向实例的指针
};

#endif // MEDIAFACEIMAGE_H
