#ifndef MQTTSUBSCRIBER_H
#define MQTTSUBSCRIBER_H
#include <MQTTClient.h>
#include <MQTTAsync.h>

#include <QObject>
#include "VidesData.h"
class MqttSubscriber : public QObject
{
    Q_OBJECT
public:
    static MqttSubscriber* getInstance(vides_data::MqttConfig& config, QObject* parent = nullptr);    ~MqttSubscriber();

    void start();
private:
    MqttSubscriber(vides_data:: MqttConfig& config, QObject* parent = nullptr);
    MqttSubscriber(const MqttSubscriber&) = delete;
    MqttSubscriber& operator=(const MqttSubscriber&) = delete;

    MQTTAsync client;

    vides_data::MqttConfig config;

    void onConnect(MQTTAsync_successData* response);

    void onConnectFailure(MQTTAsync_failureData* response);

    void onSubscribe(MQTTAsync_successData* response);
    void onSubscribeFailure(MQTTAsync_failureData* response);

    void connectionLost(char* cause);
    int messageArrived(char* topicName, int topicLen, MQTTAsync_message* m);

    void onPublishSuccess(MQTTAsync_successData* response);
    void onPublishFailure(MQTTAsync_failureData* response);

    void sendSubscriptionConfirmation(const vides_data::requestMqttData& response);
    static MqttSubscriber* instance;
};


#endif // MQTTSUBSCRIBER_H
