#include "TaskRunnable.h"

TaskRunnable::TaskRunnable(std::function<void()> newTask, int hDevice, int channel, RunFunction func)
    :m_hDevice(hDevice), m_channel(channel), runFunction(func){
    if (runFunction == SdkDevSnapSyn) {
        this->devSnapSyn = newTask;
    }
    if(runFunction==SdkCallbackFunction){
        this->callbackFunction = newTask;
    }
    
    this->setAutoDelete(true);
}
TaskRunnable::~TaskRunnable(){
    static int i=0;
    printf("TaskRunnable被析构%d次\n", ++i);
    
}
void TaskRunnable::setString(const QString& str){
    this->szString=str;
}
void TaskRunnable::setHdevice(const int& hDevice){
    this->m_hDevice=hDevice;
}
void TaskRunnable::setChannel(const int& channel){
    this->m_channel=channel;
}
void TaskRunnable::setRunFunction(RunFunction func) {
    this->runFunction = func;
}
void TaskRunnable::setDevSnapSyn(const DevSnapSyn& function) {
    this->devSnapSyn = function;
}

void TaskRunnable::setCallbackFunction(const CallbackFunction& function) {
    this->callbackFunction = function;
}

void TaskRunnable::run() {

    try {
        if (runFunction == SdkDevSnapSyn) {
            devSnapSyn();  // 调用函数
        } else if(runFunction == SdkCallbackFunction) {
            callbackFunction();  // 调用函数
        }
    } catch (const std::exception& e) {
        qInfo() << "在任务运行过程中发生异常：" << e.what();
    } catch (...) {
        qInfo() << "在任务运行过程中发生未知异常";
    }

}
