#ifndef COMMON_H
#define COMMON_H
#include <ctime>
#include <chrono>
#include <thread>
#include <QString>
#include <cstring>
#include <QDateTime>
#include <QByteArray>
#include <QCryptographicHash>
#include <QMessageAuthenticationCode>
#include <QNetworkInterface>

#include <QDebug>
class Common
{
public:
    Common(const Common &)=delete;
    
    void operator=(const  Common &)=delete;
    
    static Common &getInstance(){
        static Common instance;
        return instance;
    }
    QString getTimeString();

    QString timestampToDateString(qint64 timestamp);

    QString generateSignature(const QString& accessKeySecret, const QString& verb,
                              const QString& contentMD5, const QString& contentType,
                              const QString& date, const QString& ossHeaders,
                              const QString& canonicalizedResource);

    QString getVideoOut();
    
    void setVideoOut(QString videoOut);

    QString getVideoDownload();
    void setVideoDownload(QString videoDownload);
    
    QString getImages();
    void setImages(QString images);

    QString GetLocalIp();

    template <typename T>
    const T& clamp(const T& v, const T& lo, const T& hi)
    {
        return (v < lo) ? lo : (hi < v) ? hi : v;
    }
    template<typename T>
    void deleteObj(T*& obj) {
        if(obj != nullptr) {
            delete obj;
            obj = nullptr;
        }
    }

private:
    QString videoOut;
    QString videoDownload;
    QString images;
    Common();
    ~Common();
    
};

#endif // COMMON_H
