#include "Common.h"

Common::Common(){}

QString Common::getTimeString() {
    QDateTime currentDateTime = QDateTime::currentDateTime();
    QString formattedDateTime = currentDateTime.toString("yyyy-MM-dd hh:mm:ss");
    return formattedDateTime;
}
QString Common::timestampToDateString(qint64 timestamp) {
    QDateTime dateTime = QDateTime::fromSecsSinceEpoch(timestamp);
    QString formattedDate = dateTime.toString("yyyy-MM-dd hh:mm:ss");
    return formattedDate;
}
QString Common::generateSignature(const QString& accessKeySecret, const QString& verb,
                                  const QString& contentMD5, const QString& contentType,
                                  const QString& date, const QString& ossHeaders,
                                  const QString& canonicalizedResource)
{
    // 构造规范化的字符串
    QString stringToSign = verb + "\n" +
            contentMD5 + "\n" +
            contentType + "\n" +
            date + "\n" +
            ossHeaders+ "\n" +  // 添加'\n'分隔符，并确保ossHeaders末尾没有多余的空白
            canonicalizedResource;

    // 将密钥和消息转换为字节数组
    QByteArray hmacKey = accessKeySecret.toUtf8();
    QByteArray message = stringToSign.toUtf8();
    // 使用HMAC-SHA1计算签名
    QMessageAuthenticationCode mac(QCryptographicHash::Sha1);
    mac.setKey(hmacKey);
    mac.addData(message);


    QByteArray signature = mac.result().toBase64();  // 直接使用QMessageAuthenticationCode的结果

    return QString(signature);
}
QString Common::getVideoOut(){
    return videoOut;
}
void Common::setVideoOut(QString videoOut){
    videoOut.append("/");
    this->videoOut=videoOut;
}


QString Common::getVideoDownload(){
    return videoDownload;
}
void Common::setVideoDownload(QString videoDownload){
    videoDownload.append("/");
    this->videoDownload=videoDownload;
}

QString Common::getImages(){
    return images;
}
void Common::setImages(QString images){
    images.append("/");
    this->images=images;
}

float Common::getCarConfidenceMax() const{
    return carConfidenceMax;
}
void Common::setCarConfidenceMax(float carConfidenceMax){
    this->carConfidenceMax=carConfidenceMax;
}

float Common::getCarConfidenceMin() const{
    return carConfidenceMin;
}
void Common::setCarConfidenceMin(float carConfidenceMin){
    this->carConfidenceMin=carConfidenceMin;
}
QString Common::GetLocalIp() {
    QString ipAddress;
    QList<QHostAddress> list = QNetworkInterface::allAddresses();
    for (const QHostAddress& address : list) {
        if (address != QHostAddress::LocalHost && address.toIPv4Address()) {
            ipAddress = address.toString();
            break;
        }
    }
    if (ipAddress.isEmpty()) {
        ipAddress = QHostAddress(QHostAddress::LocalHost).toString();
    }
    return ipAddress;
}
Common::~Common(){}
