#ifndef COMMON_H
#define COMMON_H
#include <ctime>
#include <chrono>
#include <thread>
#include <QString>
#include <cstring>
#include <QDateTime>
#include <QByteArray>
#include <QCryptographicHash>
#include <QMessageAuthenticationCode>
#include <QNetworkInterface>

#include <QDebug>
class Common
{
public:
    Common(const Common &)=delete;
    
    void operator=(const  Common &)=delete;
    
    static Common &getInstance(){
        static Common instance;
        return instance;
    }
    QString getTimeString();

    QString timestampToDateString(qint64 timestamp);

    QString generateSignature(const QString& accessKeySecret, const QString& verb,
                              const QString& contentMD5, const QString& contentType,
                              const QString& date, const QString& ossHeaders,
                              const QString& canonicalizedResource);

    QString getVideoOut();
    
    void setVideoOut(QString videoOut);

    QString getVideoDownload();
    void setVideoDownload(QString videoDownload);
    
    QString getImages();
    void setImages(QString images);

    QString GetLocalIp();

    float getCarConfidenceMax() const;
    void setCarConfidenceMax(float carConfidenceMax);

    float getCarConfidenceMin() const;
    void setCarConfidenceMin(float carConfidenceMin);

    template<typename T>
    void deleteObj(T*& obj) {
        if(obj != nullptr) {
            delete obj;
            obj = nullptr;
        }
    }

private:
    QString videoOut;
    QString videoDownload;
    QString images;
    float carConfidenceMax;
    float carConfidenceMin;
    Common();
    ~Common();
    
};

#endif // COMMON_H
