#include "HttpService.h"

vides_data::responseStsCredentials HttpService::stsCredentials;

HttpService::HttpService() {
}
HttpService::HttpService(QString httpUrl) {
    this->httpUrl=httpUrl;
}

HttpService::~HttpService() {
    
}

vides_data::response* HttpService::httpPostDeviceStatus(vides_data::requestDeviceStatus & deviceStatus) {
    httpUrl.append("/api/v1.0/device/ping");
    
    QJsonObject json;
    json.insert("sn",deviceStatus.sSn);
    json.insert("type",deviceStatus.type);
    json.insert("state",deviceStatus.status);
    json.insert("ip_addr",deviceStatus.ip_addr);
    QJsonDocument jsonDoc;
    jsonDoc.setObject(json);
    QByteArray bytearr= jsonDoc.toJson(QJsonDocument::Compact);
    
    vides_data::response *resp=new vides_data::response();
    QNetworkRequest request;
    request.setUrl(QUrl(httpUrl));
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    if(m_httpClient.post(request,bytearr)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =std::move(maps.toVariantMap());
        resp->code=map["code"].toInt();
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<"httpPostDeviceStatus"<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}

vides_data::response* HttpService::httpPostRecord(int id,int recongnition_type,QString sn,QString videw_addr){
    httpUrl.append("/api/v1.0/recongnition/record");
    
    QJsonObject json;
    json.insert("id",id);
    json.insert("recongnition_type",recongnition_type);
    json.insert("sn",sn);
    json.insert("videw_addr",videw_addr);
    QJsonDocument jsonDoc;
    jsonDoc.setObject(json);
    QByteArray bytearr= jsonDoc.toJson(QJsonDocument::Compact);
    
    vides_data::response *resp=new vides_data::response();
    QNetworkRequest request;
    request.setUrl(QUrl(httpUrl));
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    if(m_httpClient.post(request,bytearr)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =std::move(maps.toVariantMap());
        resp->code=map["code"].toInt();
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}

void HttpService::setHttpUrl(const QString &httpUrl){
    this->httpUrl=httpUrl;
}
vides_data::response *HttpService::httpFindCameras(QString &serialNumber,vides_data::responseDeviceData&responseData) {
    httpUrl.append("/api/v1.0/device/all");
    vides_data::response *resp=new vides_data::response();
    QUrlQuery query;
    query.addQueryItem("sn",serialNumber);
    query.addQueryItem("new_token",QString::number(1));
    QNetworkRequest request;
    QUrl url(httpUrl);
    url.setQuery(query);
    request.setUrl(url);
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    if(m_httpClient.get(request)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =std::move(maps.toVariantMap());
        resp->code=map["code"].toInt();
        QJsonObject dataObj = maps["data"].toObject();
        

        // 处理"sts_credentials"字段
        QJsonObject stsCredentialsObj = dataObj["sts_credentials"].toObject();
        HttpService::stsCredentials.access_key_id=responseData.sts_credentials.access_key_id = stsCredentialsObj["access_key_id"].toString();
        HttpService::stsCredentials.access_key_secret=responseData.sts_credentials.access_key_secret = stsCredentialsObj["access_key_secret"].toString();
        HttpService::stsCredentials.bucket=responseData.sts_credentials.bucket = stsCredentialsObj["bucket"].toString();
        HttpService::stsCredentials.endpoint=responseData.sts_credentials.endpoint = stsCredentialsObj["endpoint"].toString();
        HttpService::stsCredentials.expiration=responseData.sts_credentials.expiration = stsCredentialsObj["expiration"].toString();
        HttpService::stsCredentials.security_token=responseData.sts_credentials.security_token = stsCredentialsObj["security_token"].toString();

        QJsonArray dataArray = dataObj["list"].toArray();
        for (const QJsonValue& value : dataArray) {
            vides_data::responseDeviceStatus status;
            QJsonObject deviceObject = value.toObject();
            
            status.sSn = deviceObject["sn"].toString();
            status.type = static_cast<int8_t>(deviceObject["type"].toInt());
            status.merchant_id = static_cast<int8_t>(deviceObject["merchant_id"].toInt());
            
            // 处理"areas"数组
            QJsonArray areasArray = deviceObject["areas"].toArray();
            for (const QJsonValue& areaValue : areasArray) {
                vides_data::responseArea area;
                QJsonObject areaObject = areaValue.toObject();
                area.bottom_right_corner_x = areaObject["bottom_right_corner_x"].toDouble();
                area.bottom_right_corner_y = areaObject["bottom_right_corner_y"].toDouble();
                area.top_left_corner_x = areaObject["top_left_corner_x"].toDouble();
                area.top_left_corner_y = areaObject["top_left_corner_y"].toDouble();

                area.bottom_left_corner_x = areaObject["bottom_left_corner_x"].toDouble();
                area.bottom_left_corner_y = areaObject["bottom_left_corner_y"].toDouble();
                area.top_right_corner_x = areaObject["top_right_corner_x"].toDouble();
                area.top_right_corner_y = areaObject["top_right_corner_y"].toDouble();

                status.areas.push_back(area);
            }
            
            responseData.list.push_back(status);
        }
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}
vides_data::response *HttpService::httpLicensePlateRecognition(vides_data::requestLicensePlate &licensePlateRecognition,
                                                               std::list<vides_data::responseRecognitionData>&result ){
    QNetworkRequest request;
    httpUrl.append("/api/v1.0/recongnition/plate");
    
    
    QJsonObject requestBody;
    
    // 构建"list"数组
    QJsonArray jsonArray;
    for (const auto& plate : licensePlateRecognition.plates) {
        QJsonObject item;
        QJsonObject cameraObject {
            {"bottom_right_corner_x", plate.areaLocation.bottomRightCornerX},
            {"bottom_right_corner_y", plate.areaLocation.bottomRightCornerY},
            {"top_left_corner_x", plate.areaLocation.topLeftCornerX},
            {"top_left_corner_y", plate.areaLocation.topLeftCornerY},

            {"bottom_left_corner_x", plate.areaLocation.bottomLeftCornerX},
            {"bottom_left_corner_y", plate.areaLocation.bottomLeftCornerY},
            {"top_right_corner_x", plate.areaLocation.topRightCornerX},
            {"top_right_corner_y", plate.areaLocation.topRightCornerY}
        };
        item.insert("camera_location", cameraObject);


        item.insert("img", QJsonValue::fromVariant(plate.img));  // 替换为真实的图像数据
        QJsonObject locationObject {
            {"bottom_right_corner_x", plate.recognition.bottomRightCornerX},
            {"bottom_right_corner_y", plate.recognition.bottomRightCornerY},
            {"top_left_corner_x", plate.recognition.topLeftCornerX},
            {"top_left_corner_y", plate.recognition.topLeftCornerY},

            {"bottom_left_corner_x", plate.recognition.bottomLeftCornerX},
            {"bottom_left_corner_y", plate.recognition.bottomLeftCornerY},
            {"top_right_corner_x", plate.recognition.topRightCornerX},
            {"top_right_corner_y", plate.recognition.topRightCornerY}
        };

        item.insert("location", locationObject);
        item.insert("new_color", plate.new_color);  // 替换为真实的颜色数据
        item.insert("new_plate", plate.new_plate);  // 使用LicensePlate结构中的车牌号字段
        item.insert("time",  QJsonValue::fromVariant(plate.time));  // 替换为真实的时间数据
        jsonArray.append(item);
    }
    
    // 将"list"数组添加到JSON对象中
    requestBody.insert("list", jsonArray);
    
    // 添加其他字段
    requestBody.insert("sn", licensePlateRecognition.sn);
    QJsonDocument doc(requestBody);
    QByteArray bytearr= doc.toJson(QJsonDocument::Compact);
    
    vides_data::response *resp=new vides_data::response();
    request.setUrl(QUrl(httpUrl));
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    if(m_httpClient.post(request,bytearr)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =std::move(maps.toVariantMap());
        resp->code=map["code"].toInt();
        resp->msg=map["message"].toString();

        QJsonObject data = map["data"].toJsonObject();
        QJsonArray dataList = data["list"].toArray();  // 获取 "list" 数组
        for (const auto& item : dataList) {
            QJsonObject currentItem = item.toObject();
            vides_data::responseRecognitionData res;
            res.id = currentItem["id"].toInt();
            res.inTime = currentItem["in_time"].toInt();
            res.outTime = currentItem["out_time"].toInt();
            res.recognitionType = currentItem["recongnition_type"].toInt();
            res.sn = currentItem["sn"].toString();
            result.push_back(res);
            // 将 res 添加到结果列表或进行其他操作
        }
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}
vides_data::response* HttpService::httpFindFaceReconition(QString &serialNumber, std::list<vides_data::responseFaceReconition *> &datas){
    QNetworkRequest request;
    
    httpUrl.append("/api/v1.0/recongnition/face_list");
    vides_data::response *resp=new vides_data::response();
    QUrlQuery query;
    query.addQueryItem("sn",serialNumber);
    QUrl url(httpUrl);
    url.setQuery(query);
    request.setUrl(url);
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    if(m_httpClient.get(request)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =std::move(maps.toVariantMap());
        resp->code=map["code"].toInt();
        
        QJsonArray dataArray = map["data"].toJsonArray();  // 将"data"字段转换为QJsonArray
        
        for (const QJsonValue& value : dataArray) {
            vides_data::responseFaceReconition *res=new  vides_data::responseFaceReconition();
            QJsonObject dataObject = value.toObject();  // 将数组中的每个元素转换为QJsonObject
            res->id= QString::number(dataObject["id"].toInt());
            res->img = dataObject["img"].toString();
            datas.push_back(res);
        }
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}
vides_data::response *HttpService::httpPostFacePopulation(QByteArray &img,int &number,QString sn,qint64 time){
    httpUrl.append("/api/v1.0/recongnition/population");
    QJsonObject json;
    json.insert("img", QJsonValue::fromVariant(img));
    json.insert("sn",sn);
    json.insert("number",number);
    json.insert("time",QJsonValue::fromVariant(time));
    QJsonDocument jsonDoc;
    jsonDoc.setObject(json);
    QByteArray bytearr= jsonDoc.toJson(QJsonDocument::Compact);

    vides_data::response *resp=new vides_data::response();
    QNetworkRequest request;
    request.setUrl(QUrl(httpUrl));
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    if(m_httpClient.post(request,bytearr)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =maps.toVariantMap();
        resp->code=map["code"].toInt();
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}

vides_data::response *HttpService::httpPostFaceReconition(vides_data::requestFaceReconition & faceReconition){
    httpUrl.append("/api/v1.0/recongnition/face");
    QJsonObject json;
    json.insert("id",QJsonValue::fromVariant(faceReconition.id.toInt()));
    json.insert("img", QJsonValue::fromVariant(faceReconition.img));
    json.insert("sn",faceReconition.sn);
    json.insert("time",QJsonValue::fromVariant(faceReconition.time));

    // 创建 location 对象
    QJsonObject location;
    location.insert("bottom_right_corner_x", faceReconition.area.bottom_right_corner_x);
    location.insert("bottom_right_corner_y", faceReconition.area.bottom_right_corner_y);
    location.insert("top_left_corner_x",faceReconition.area.top_left_corner_x);
    location.insert("top_left_corner_y",faceReconition.area.top_left_corner_y);

    location.insert("bottom_left_corner_x", faceReconition.area.bottom_left_corner_x);
    location.insert("bottom_left_corner_y", faceReconition.area.bottom_left_corner_y);
    location.insert("top_right_corner_x",faceReconition.area.top_right_corner_x);
    location.insert("top_right_corner_y",faceReconition.area.top_right_corner_y);


    // 将 location 对象插入到主 json 对象中
    json.insert("location", location);

    QJsonDocument jsonDoc;
    jsonDoc.setObject(json);
    QByteArray bytearr= jsonDoc.toJson(QJsonDocument::Compact);
    
    vides_data::response *resp=new vides_data::response();
    QNetworkRequest request;
    request.setUrl(QUrl(httpUrl));
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);

    if(m_httpClient.post(request,bytearr)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =std::move(maps.toVariantMap());
        resp->code=map["code"].toInt();
        resp->msg=map["message"].toString();
    }else{
        resp->code=2;
        resp->msg=m_httpClient.errorString();
        //resp->msg=OPERATION_FAILED;
    }
    return resp;
}
vides_data::response*HttpService::httpFindGb28181Config(QString &serialNumber){
    httpUrl.append("/api/v1.0/gb28181/config");
    vides_data::response *resp=new vides_data::response();
    QUrlQuery query;
    query.addQueryItem("sn",serialNumber);
    QNetworkRequest request;
    QUrl url(httpUrl);
    url.setQuery(query);
    request.setUrl(url);
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    
    if(m_httpClient.get(request)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =std::move(maps.toVariantMap());
        resp->code=map["code"].toInt();
        vides_data::responseGb28181 *response=new vides_data::responseGb28181();
        QJsonObject data = map["data"].toJsonObject();  // 将"data"字段转换为QJsonArray
        response->sip_ip = data["sip_ip"].toString();
        QString sip=data["sip_port"].toString();
        response->sip_port =sip.toInt();
        response->serial = data["serial"].toString();
        response->realm = data["realm"].toString();
        response->username = data["username"].toString();
        response->password = data["password"].toString();
        response->register_validity = data["register_validity"].toInt();
        response->heartbeat_interval = data["heartbeat_interval"].toInt();
        response->device_id = data["device_id"].toString();
        response->channel_id = data["channel_id"].toString();
        resp->data=response;
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=m_httpClient.errorString();
    }
    return resp;
}


vides_data::response*HttpService::httpFindStream(QString &serialNumber){
    httpUrl.append("/api/v1.0/stream");
    vides_data::response *resp=new vides_data::response();
    QUrlQuery query;
    query.addQueryItem("sn",serialNumber);
    QNetworkRequest request;
    QUrl url(httpUrl);
    url.setQuery(query);
    request.setUrl(url);
    request.setRawHeader(vides_data::HEADER_TYPE_KAY, vides_data::HEADER_TYPE_VALUE);
    QMutexLocker locker(&m_httpClientMutex);
    
    if(m_httpClient.get(request)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =maps.toVariantMap();
        resp->code=map["code"].toInt();
        
        QJsonObject data = map["data"].toJsonObject();  // 将"data"字段转换为QJsonArray
        QString pushStream = data["push_stream"].toString();
        QByteArray byteArray = pushStream.toUtf8();
        resp->data=byteArray.data();
        
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}
vides_data::response *HttpService::httpDownload( const QString &filePath,QString &fullPathName){
    vides_data::response *resp=new vides_data::response();
    QUrl url(httpUrl);
    
    QNetworkRequest request;
    request.setUrl(url);
    QString fileName = url.fileName();

    QMutexLocker locker(&m_httpClientMutex);
    
    if(m_httpClient.downloadFile(request,filePath,fullPathName,fileName)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =maps.toVariantMap();
        resp->code=map["code"].toInt();
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}
vides_data::response*HttpService::httpUploadFile(const QString &filePath,QString& accessKeyId,
                                                 QString& accessKeySecret,QString & bucketName,QString &securityToken){
    vides_data::response *resp=new vides_data::response();
    QUrl url(httpUrl);
    
    QNetworkRequest request;
    request.setUrl(url);
    QMutexLocker locker(&m_httpClientMutex);
    if(m_httpClient.uploadFile(request,accessKeyId,accessKeySecret,filePath,bucketName,securityToken)){
        QByteArray && byte=m_httpClient.text().toUtf8();
        QJsonDocument docujson= QJsonDocument::fromJson(byte.data());
        QJsonObject maps= docujson.object();
        QVariantMap map =maps.toVariantMap();
        resp->code=map["code"].toInt();
        resp->msg=map["message"].toString();
    }else{
        qDebug()<<m_httpClient.errorCode();
        resp->code=2;
        resp->msg=OPERATION_FAILED;
    }
    return resp;
}
