#include "ThreadSafeQueue.h"
template <typename T>
ThreadSafeQueue<T>::ThreadSafeQueue(int maxCount)
    : maxCount_(maxCount)
{
}

template <typename T>
bool ThreadSafeQueue<T>::push(const T& value) {
    std::lock_guard<std::mutex> lock(mutex_);
    if (queue_.size() < maxCount_) {
        queue_.push_back(value);
        return true;
    }
    return false;
}

template <typename T>
bool ThreadSafeQueue<T>::pop(T& value) {
    std::lock_guard<std::mutex> lock(mutex_);
    if (!queue_.empty()) {
        value = queue_.front();
        queue_.pop_back();
        return true;
    }
    return false;
}

template <typename T>
bool ThreadSafeQueue<T>::empty() const {
    std::lock_guard<std::mutex> lock(mutex_);
    return queue_.empty();
}

template <typename T>
bool ThreadSafeQueue<T>::full() const {
    std::lock_guard<std::mutex> lock(mutex_);
    return queue_.size() >= maxCount_;
}

template <typename T>
int ThreadSafeQueue<T>::size() const {
    std::lock_guard<std::mutex> lock(mutex_);
    return queue_.size();
}
