#ifndef VIDESDATA_H
#define VIDESDATA_H

#include "XNetSDKDefine.h"
#include<QString>
#include <QProcess>
#include <QDate>
#include <QProcess>
#include <QRegularExpression>
#include <QFile>
#include <QTextStream>
#include <QByteArray> 
#include <QNetworkInterface>
#include <list>
namespace vides_data{
constexpr const char *HEADER_TYPE_KAY="Content-Type";
constexpr const char *HEADER_TYPE_VALUE="application/json";
constexpr const char *PROFLIE_TEST= "test";
struct response
{
    int code;
    void* data;
    QString msg;
    response() {}
};
struct requestDeviceStatus
{
    QString sSn;
    int8_t type;
    int8_t status;
    QString ip_addr;
    requestDeviceStatus() {}
};
struct responseStsCredentials{
    QString access_key_id;
    QString access_key_secret;
    QString bucket;
    QString endpoint;
    QString expiration;
    QString security_token;
};
struct responseGb28181 {
    QString sip_ip;
    int sip_port;
    QString serial;
    QString realm;
    QString username;
    QString password;
    int register_validity;
    int heartbeat_interval;
    QString device_id;
    QString channel_id;
};
struct responseArea {
    float bottom_right_corner_x;
    float bottom_right_corner_y;
    float bottom_left_corner_x;
    float bottom_left_corner_y;
    
    float top_left_corner_x;
    float top_left_corner_y;
    float top_right_corner_x;
    float top_right_corner_y;
};
struct responseDeviceStatus
{
    QString sSn;
    int8_t type;
    int8_t merchant_id;
    std::list<responseArea>areas;
    responseDeviceStatus() {}
};
struct responseDeviceData{
    std::list<responseDeviceStatus> list;
    responseStsCredentials sts_credentials;
};

struct localDeviceStatus
{
    QString sSn;
    int8_t type;
    int8_t merchant_id;
    SXSDK_IPAddress HostIP;
    int HttpPort;
    int TCPPort;
    int ChannelNum;
    QString UserName;
    QString password;
    localDeviceStatus() {}
};
struct requestFaceReconition
{
    QString id;
    QByteArray  img;
    QString sn;
    qint64 time;
    responseArea area;
    requestFaceReconition() {}
};

struct faceRecognitionResult
{
    QString id;
    uint32_t x;
    uint32_t y;
    uint32_t width;
    uint32_t height;
    faceRecognitionResult() {}
};
struct responseFaceReconition
{
    QString id;
    QString  img;
    responseFaceReconition() {}
};
struct ParkingArea
{
    float topLeftCornerX;
    float topLeftCornerY;
    float bottomLeftCornerX;
    float bottomLeftCornerY;
    float bottomRightCornerX;
    float bottomRightCornerY;
    float topRightCornerX;
    float topRightCornerY;
    ParkingArea() {}
};
struct LicensePlate
{
    ParkingArea areaLocation;
    QString new_plate;
    QString new_color;
    QByteArray  img;
    qint64 time;
    ParkingArea recognition;
    float text_confidence;
    LicensePlate() {}
};

struct requestLicensePlate
{  
    QString sn;
    std::list<LicensePlate> plates;
    requestLicensePlate() {}
};

struct cameraParameters
{
    QString sDevId;
    int nDevPort;
    QString sUserName;
    QString sPassword;
    int channel;
    QString httpUrl;
    QString sSn;
    QString rtspUrl;
    QString rtmpUrl;
    cameraParameters() {}
};
struct NetWorkNetCommon {
    char* GateWay;        // 网关IP
    char* HostIP;         // 主机IP
    char* HostName;       // 主机名
    int HttpPort;           // HTTP服务端口
    char* MAC;            // MAC地址
    int MaxBps;             // 限定码流值
    char* MonMode;        // 监视协议 {"TCP","UDP","MCAST",…}
    int SSLPort;            // SSL侦听端口
    char* Submask;        // 子网掩码
    int TCPMaxConn;         // 最大连接数
    int TCPPort;            // TCP侦听端口
    char* TransferPlan;   // 传输策略"AutoAdapt":自适应, "Quality":质量优先, "Fluency":流量优先，"Transmission":网传优先
    int UDPPort;            // UDP侦听端口
    bool UseHSDownLoad;     // 是否启用高速录像下载
};


struct responseRecognitionData
{
    int id;
    qint64 inTime;
    qint64 outTime;
    int recognitionType;
    QString sn;
};
inline bool isVirtualMachine()
{
    QString dmiPath;
    
#ifdef Q_OS_WIN
    dmiPath = "HKEY_LOCAL_MACHINE\\HARDWARE\\DESCRIPTION\\System";
#else
    dmiPath = "/sys/devices/virtual/dmi/id/";
#endif
    
    QFile file(dmiPath);
    return file.exists();
}
inline QString getDefaultGateway() {
    QProcess process;
    QString gateway;
    // 根据操作系统的不同选择不同的命令
#ifdef Q_OS_WIN
    QString command = "ipconfig";
    QStringList arguments;
    arguments << "/all";
#elif defined(Q_OS_LINUX)
    QString command = "ip";
    QStringList arguments;
    arguments << "route" << "show" << "default";
#elif defined(Q_OS_MAC)
    QString command = "netstat";
    QStringList arguments;
    arguments << "-nr";
#endif
    
    process.start(command, arguments);
    
    // 等待进程结束
    process.waitForFinished();
    
    // 读取并处理输出
    QString output(process.readAllStandardOutput());
    
#ifdef Q_OS_WIN
    // 使用正则表达式来查找默认网关
    QRegExp rx("Default Gateway[ .]*: (.+?)(\r\n|\n)");
    if (rx.indexIn(output) != -1) {
        gateway = rx.cap(1).trimmed();
    }
#elif defined(Q_OS_LINUX) || defined(Q_OS_MAC)
    // 对于Linux和Mac，分行并查找包含default字样的行
    QStringList lines = output.split('\n');
    QRegularExpression rx("^default via (\\S+)");
    foreach (const QString &line, lines) {
        QRegularExpressionMatch match = rx.match(line);
        if (match.hasMatch()) {
            gateway = match.captured(1);
            break;
        }
    }
    
#endif
    return gateway;
}
inline bool pingAddress(const QString &address) {
    QProcess process;
    QString program = "ping";
    QStringList arguments;
    
    arguments << "-c" << "1" << address; // -c 1 表示发送一个 Ping 包
    
    process.start(program, arguments);
    process.waitForFinished();
    
    QString output(process.readAllStandardOutput());
    
    return output.contains("1 packets transmitted, 1 received");
}
inline QString getSerialNumber() {
    QProcess process;
    // 使用管道将两个命令的执行结果串联起来，直接查找包含"Serial"的行
    process.start("bash", QStringList() << "-c" << "cat /proc/cpuinfo | grep Serial");
    process.waitForFinished(-1); // 等待命令执行完成
    
    QString output = process.readAllStandardOutput();
    QString serialNumber;
    if (!output.isEmpty()) {
        // 已经确保了输出仅包含 Serial 行，所以直接分割并提取
        serialNumber = output.split(":").at(1).trimmed();
    }
    
    return serialNumber;
}
}


#endif // VIDESDATA_H
