#ifndef FACERECONITIONHANDLE_H
#define FACERECONITIONHANDLE_H
#include "BaseAlgorithm.h"
#include "hyperface.h"

#include "herror.h"
#include "LogHandle.h"
#include "VidesData.h"
#include "ScopeSemaphoreExit.h"
#include <opencv2/opencv.hpp>
#include<QCoreApplication>


class FaceReconitionHandle  : public BaseAlgorithm {

private:
    HContextHandle ctxHandle=nullptr;

    float configConfidence;

    std::vector<int32_t>customIds;

    std::map<QString,int32_t>mapCustomId;

    std::atomic<bool>isImageChanged{false};
public:
    FaceReconitionHandle();
    ~FaceReconitionHandle();

    cv::Mat loadImage(const QString &path);
    cv::Mat loadImageFromByteStream(const QString& filePath);

    cv::Mat loadQImageFromByteStream(const QString& filePath);

    cv::Mat loadImageWithSTB(const QString& filename);


    bool getImageChanged()const;

    void setImageChanged(bool imageChanged);


    void doesItExistEmployee(const QString &sn,const cv::Mat &source,std::list<vides_data::faceRecognitionResult>&face);

    void initSourceImageMap(std::map<QString,QString>&maps,int numberFaces,float confidence);

    void featureRemove();

    void featureRemoveMap(std::map<QString,QString>&maps);


};
#endif // FACERECONITIONHANDLE_H
