#ifndef HTTPCLIENT_H
#define HTTPCLIENT_H
#include "Common.h"
#include <QHttpPart>
#include <QSsl>
#include <QObject>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QEventLoop>
#include <QFile>
#include <QTimer>
#include <QTextCodec>
#include <QDir>
#include <QRandomGenerator>
#include <QSslConfiguration>

class HttpClient : public QObject
{
    Q_OBJECT
public:
    explicit HttpClient(QObject *parent = nullptr);
    
    ~HttpClient();
    
    bool get(QNetworkRequest &request);
    
    bool post(QNetworkRequest &request, const QByteArray &data);
    
    bool downloadFile(QNetworkRequest request, const QString& filePath,
                      QString &fullPathName,QString &extension);
    
    bool uploadFile(QNetworkRequest request,const QString& accessKeyId,
                    const QString& accessKeySecret,const QString& filePath,
                    QString & bucketName,QString &securityToken);
    QString errorCode() const;
    QString errorString() const;
    
    QString text() const;
    QString FileName() const;
    void setFileName(QString fileName);

    
private:
    void processReply(QNetworkReply *reply);
    
private:
    QNetworkAccessManager       *m_networkAccessManager = nullptr;
    QNetworkReply::NetworkError  m_error;
    QString                      m_text; // 存放网络请求返回的文本字符串
    QString                      m_errorString;//存放错误信息
    int                          m_networkErrorRetry = 0;    // 网络错误重试次数
    QEventLoop                   m_eventLoop;
    QTimer                      *m_timer = nullptr;
    QByteArray                   m_data; // 存放网络请求返回的原始数据
};


#endif // HTTPCLIENT_H
