#ifndef LICENSEPLATERECOGNITION_H
#define LICENSEPLATERECOGNITION_H
#include "hyper_lpr_sdk.h"
#include "LogHandle.h"
#include "VidesData.h"
#include "BaseAlgorithm.h"
#include <QString>
#include <opencv2/opencv.hpp>
#include <QTextStream>
#include <QFile>
#include <QImage>
#include <QRegularExpression>
#include <atomic>

const std::vector<std::string> types =
{"蓝牌", "黄牌单层", "白牌单层", "绿牌新能源", "黑牌港澳",
 "香港单层", "香港双层", "澳门单层", "澳门双层", "黄牌双层"};
class LicensePlateRecognition: public BaseAlgorithm {

public:

    //识别车牌号
    void licensePlateNumber(const cv::Mat &source,QString & lpNumber, vides_data::requestLicensePlate &plate,
                            qint64 currentTime);
    
    void filterLicensePlateConfidenceMax(vides_data::requestLicensePlate &plate,vides_data::LicensePlate &max);
    void oldLicensePlateNumber(const cv::Mat &source,const QString &modelPaths,QString & lpNumber);
    
    void replaceWith1And0( QString &code);
    
    
    LicensePlateRecognition(const QString &modelPaths,bool is_high,int maxNum,
                   bool useHalf,float boxThreshold,float nmsThreshold,float recThreshold
                            );
    LicensePlateRecognition();

    
    ~LicensePlateRecognition();

    
private:    
    P_HLPR_Context ctx=nullptr ;

    
};


#endif // LICENSEPLATERECOGNITION_H
