#ifndef THREADSAFEQUEUE_H
#define THREADSAFEQUEUE_H
#include <vector>
#include <mutex>
template <typename T>
class ThreadSafeQueue {
public:
    ThreadSafeQueue(int maxCount);
    bool push(const T& value);
    bool pop(T& value);
    bool empty() const;
    bool full() const;
    int size() const;

private:
    std::mutex mutex_;
    std::vector<T> queue_;
    int maxCount_;
};


#endif // THREADSAFEQUEUE_H
