#ifndef  HANDLERTSP_H
#define HANDLERTSP_H

#include "LogHandle.h"
#include "FaceRecognition.h"
#include "hyper_lpr_sdk.h"
#include "Common.h"
#include <HandleRtsp.h>
#include <QDebug>
#include <QString>
#include <QThread>
#include <ctime>
#include <QSemaphore>
#include <opencv2/opencv.hpp>
#include <QtCore/QAtomicInteger>



class HandleRtsp:public QThread
{
    Q_OBJECT
public:
    HandleRtsp(const QString & respUrl,QSemaphore& semaphore,QObject *parent=nullptr);

    void run () override;

    void setFrameCounter(int frameCounter);

    bool getFrameCounterStatus();

    ~HandleRtsp();
signals:
    void frameReady(const cv::Mat & frame,const QString &url);

    void streamInterrupted(const QString &url);
private:
     QString respUrl;

     volatile bool stopFlag;

     volatile bool isFrameCounter;

     QSemaphore & semaphore;

     std::map<int,cv::Mat>maps;

     QAtomicInteger<int> frameCounter;
};

#endif // HANDLERTSP_H
