#ifndef MQTTSUBSCRIBER_H
#define MQTTSUBSCRIBER_H
#include <MQTTClient.h>
#include <MQTTAsync.h>
#include <QTimer>

#include <QObject>
#include "VidesData.h"
class MqttSubscriber : public QObject
{
    Q_OBJECT
public:
    static MqttSubscriber* getInstance( QObject* parent = nullptr);    ~MqttSubscriber();

    void init(vides_data:: MqttConfig& config,QString &httpUrl,QString &serialNumber);
    void start();
signals:
   void connectionLostSignal();

private slots:
    void reconnectAndFetchConfig();
private:
    MqttSubscriber(QObject* parent = nullptr);
    MqttSubscriber() = delete;
    MqttSubscriber& operator=(const MqttSubscriber&) = delete;

    QTimer *retryTimer;

    MQTTAsync client;
    QString httpUrl;
    QString serialNumber;

    vides_data::MqttConfig config;

    void onConnect(MQTTAsync_successData* response);

    void onConnectFailure(MQTTAsync_failureData* response);

    void onSubscribe(MQTTAsync_successData* response);
    void onSubscribeFailure(MQTTAsync_failureData* response);

    void connectionLost(char* cause);
    int messageArrived(char* topicName, int topicLen, MQTTAsync_message* m);

    void onPublishSuccess(MQTTAsync_successData* response);
    void onPublishFailure(MQTTAsync_failureData* response);

    void sendSubscriptionConfirmation(const vides_data::requestMqttData& response,QString &sn);
    static MqttSubscriber* instance;
};


#endif // MQTTSUBSCRIBER_H
