#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "Common.h"
#include "CameraHandle.h"
#include "HttpService.h"
#include "VidesData.h"
#include "MediaFaceImage.h"
#include "AlgorithmTaskManage.h"
#include "MqttSubscriber.h"
#include <algorithm>
#include <QString>
#include <QTextCodec>
#include <QObject>
#include <QByteArray>
#include <QSettings>
#include <QTimer>
#include <QSemaphore>
#include <QDebug>
#include <QResource>
#include <opencv2/opencv.hpp>
#include <QRandomGenerator>
#include <QTcpServer>
#include <QTcpSocket>
//namespace Ui { class MainWindow; }


class MainWindow : public QObject
{
    Q_OBJECT
    
public:
    explicit MainWindow();
    
    void initCommon();
    
    void setVideoPath(int flag, const QString& path);
    
    void createDirectory(int flag,const QString& dirName, const QString& successMsg, const QString& failureMsg);
    
    void runOrRebootMqtt(vides_data::MqttConfig &mqtt_config,QString &httpUrl,QString &serialNumber);
    
    void initFaceFaceRecognition();
    
    void initCameras(vides_data::cameraParameters &parameter, vides_data::responseConfig &devConfig, const std::list<vides_data::responseArea>&areas,std::list<vides_data::requestCameraInfo>&camera_info_list);
    
    __uint8_t intToUint8t(bool faceAlgorithm,bool licensePlateAlgorithm,bool uniformAlgorithm,bool humanAlgorithm);
    //盒子参数更新
    void divParameterUpdate(vides_data::responseConfig &cloudConfig,QString &httpUrl,QString &serialNumber );
    
    static MainWindow * sp_this;
    
    CameraHandle* findHandle(QString sn);

    void modifySnMapIp(QString &sn,QString &ip);
    void findSnMapIp(QString &sn,QString &ip);
    
    void sendJsonResponse(QTcpSocket* socket, int code, const QString& data, const QString& msg);
    void sendEmptyResponse(QTcpSocket* socket);
    void sendNotFoundResponse(QTcpSocket* socket);
    
    void updateLocalFace(const QString &httpurl);
    
    void removeImageFiles(QString id);
    
    void modifyImagesAndNames(QString &modId,std::map<QString, QString> &currentImageMap);
    
    void findLocalSerialNumber(QString &serialNumber);
    
    void initDevConfigSyn(CameraHandle *cameraHandle,vides_data::responseConfig &devConfig);
    
    void initRecordingToString(QString &recorJson);
    
    void initDeviceEncodeToString(vides_data::responseConfig &source, QString &targetCodeJson);
    
    void initEncodeToString(QString &enCodeJson);
    
    void clearOfflineCameraHandle(QString sDevId, int nDevPort);
    
    bool iniWorkSpVMn(vides_data::responseGb28181 *gb28181,QString &workSpWMn,QString &sn);
    
    bool isDeviceInList(const QString& deviceId, const  std::list<vides_data::responseDeviceStatus>& devices);
    // 过滤函数
    void deleteCloudNotCamer (const std::map<QString,vides_data::localDeviceStatus*>& localDevices,
                              const std::list<vides_data::responseDeviceStatus>& devices);
    
    void setIsResetting(bool running);
    
    
    ~MainWindow();
signals:
    void shutdownSignals(QString sDevId, int nDevPort);
    
private slots:
    void startCamera(const QString &httpurl);
    
    void deleteLogFile();
    
    void clearHandle(QString sDevId, int nDevPort);
    
    void handleMatNewConnection();
private:
    //Ui::MainWindow *ui;
    
    QSettings *qSetting;
    
    QTimer *deleteLogFileTimer;
    
    QTimer*dePermissionSynTimer;
    
    QTcpServer server;
    
    QString localSn;
    
    //本地id:图片路径
    std::map<QString,QString>localImageMap;
    //云端id:oss路径
    std::map<QString,QString>cloudImageMap;
    
    QString modelPaths;
    
    std::map<QString,CameraHandle*>faceDetectionParkingPushs;
    
    vides_data::responseConfig config;
    
    vides_data::MqttConfig mqttConfig;
        
    std::atomic<bool> isResetting;
    
};
#endif // MAINWINDOW_H
