#ifndef COMMON_H
#define COMMON_H


#include <ctime>
#include <chrono>
#include <thread>
#include <QString>
#include <cstring>
#include <QDateTime>
#include <QByteArray>
#include <QCryptographicHash>
#include <QMessageAuthenticationCode>
#include <QNetworkInterface>
#include <map>
#include <iostream>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <netinet/ip_icmp.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <arpa/inet.h>
#include <net/if_arp.h>
#include <linux/route.h>
#include <ifaddrs.h>
#include <netdb.h>

#define ICMP_HDRLEN 8
#define PAYLOAD_SIZE 56

// ICMP 头部结构体
struct ICMPHeader {
    uint8_t type;        // 类型
    uint8_t code;        // 代码
    uint16_t checksum;   // 校验和
    uint16_t id;         // 标识符
    uint16_t sequence;   // 序列号
};

class Common
{
public:
    Common(const Common &)=delete;
    
    void operator=(const  Common &)=delete;
    
    static Common &getInstance(){
        static Common instance;
        return instance;
    }
    QString getTimeString();

    QString timestampToDateString(qint64 timestamp);

    QString generateSignature(const QString& accessKeySecret, const QString& verb,
                              const QString& contentMD5, const QString& contentType,
                              const QString& date, const QString& ossHeaders,
                              const QString& canonicalizedResource);

    QString getVideoOut();
    
    void setVideoOut(QString videoOut);

    QString getVideoDownload();
    void setVideoDownload(QString videoDownload);

    unsigned short calculate_checksum(void *b, int len) ;

    //确定当前网络接口
    void determine_interface(char *interface);

    QString GetLocalGateWay();//获取本机gateway
   
    bool pingAddress(const QString &address) ;

    QString getImages();
    void setImages(QString images);

    QString GetLocalIp();

    QString DecIpToHexIp(const QString& decIp);

    template <typename T>
    const T& clamp(const T& v, const T& lo, const T& hi)
    {
        return (v < lo) ? lo : (hi < v) ? hi : v;
    }
    template<typename T>
    void deleteObj(T*& obj) {
        if(obj != nullptr) {
            delete obj;
            obj = nullptr;
        }
    }

private:
    QString videoOut;
    QString videoDownload;
    QString images;
    
    Common();
    ~Common();
    
};

#endif // COMMON_H
