#ifndef CAMERAHANDLE_H
#define CAMERAHANDLE_H
#include "RecognitionInfo.h"
#include "FaceRecognition.h"
#include "HttpService.h"
#include "LicensePlateRecognition.h"
#include "Json_Header/AlarmInfo.h"
#include "Json_Header/NetWork_NetCommon.h"
#include "Json_Header/OPTimeSetting.h"
#include "Json_Header/Simplify_Encode.h"
#include "Json_Header/System_TimeZone.h"
#include "Json_Header/RecordCfg.h"
#include "Json_Header/NetWork_SPVMN.h"
#include "mainwindow.h"
#include "ParkingSpaceInfo.h"
#include "so_human_sdk.h"
#include "hyper_lpr_sdk.h"
#include <QPolygon>
#include <QPainterPath>
#include <QProcess>
#include <QDateTime>
#include <QJsonDocument>
#include <memory>
#include <functional>
#include <QString>
#include <QObject>
#include <QTimer>
#include <QThreadPool>
#include <QQueue>
#include <opencv2/opencv.hpp>
#include <QSemaphore>
#include <atomic>
enum CAR_INFORMATION {
    Exit,   //出场
    Mobilization, //进场
    ExitAndMobilization //
};
class CameraHandle: public QObject {
    Q_OBJECT
public:
    CameraHandle(QString &url,QString &httpUrl,QString &sSn, int &channel,const QString &modelPaths,
                 float carConfidence,int imageSave);
    CameraHandle();
    ~CameraHandle();
    int sdkDevLoginSyn(QString sDevId, int nDevPort, QString sUserName, QString sPassword, int nTimeout);
    //int SdkMediaGetFaceImage(int hDevice, int nSeq, int nTimeout);
    int sdkDevSetAlarmListener(XSDK_HANDLE hDevice, int bListener);

    int getHdevice();

    int getChannel();

    void clearCameraHandle();

    //    void rebindTimer(int hDevice);
    void initSdkRealTimeDevSnapSyn(int hDevice,int syn_timer,uint64 face_frequency);

    void updateImage(const cv::Mat & frame,qint64 currentTime);

    void matToBase64(const cv::Mat &image, QByteArray &base64Data);
    int callbackFunction(XSDK_HANDLE hObject,QString &szString);

    void checkAndUpdateCurrentPlate(ParkingSpaceInfo*park,const cv::Mat & frame,RecognizedInfo& newInfo,int &result,std::map<int,RecognizedInfo>&exitAndMoMap);

    void licensePlateRecognitionResults(vides_data::requestLicensePlate &location);

    void sdkDevSnapSyn(XSDK_HANDLE hDevice, int nChannel);
    //时间设置
    void sdkDevSystemTimeZoneSyn(QString &time);
    //录像设置
    void sdkRecordCfg(const char * recordJson);
    //配置编码设置
    void sdkEncodeCfg(const char *enCode);
    //28181更新
    void sdkDevSpvMn(const char* spvMn);

    void sdkDownloadFileByTime(XSDK_HANDLE hDevice,int id,
                               QString startTimer,QString endTime);

    void setTimeoutMs(int timeoutMs);


    QString getSSn();
    int getMediaHandle();
    void setMediaHandle(int mediaHandle);

    void setCurrentFace(int currentFace);

    void initParkingSpaceInfo(const std::list<vides_data::responseArea>&areas);

    bool compareLists(const std::list<vides_data::responseArea>& newAreas);

    void updateParkMapAndParkingSpaceInfos(const std::list<vides_data::responseArea>&newAreas);

    std::map<int, vides_data::responseRecognitionData>&getVideoCurrentData();
    std::map<QString, QString>&getCurrentData();

    // 检查点是否在多边形内
    bool polygonsOverlap(ParkingSpaceInfo &poly1, ParkingSpaceInfo &poly2);
    // 计算两个多边形的交集面积
    double calculateIntersectionArea(const QPolygonF &polygon1, const QPolygonF &polygon2);
    double ccw(const QPointF& a, const QPointF& b, const QPointF& c);

    void getCurrentFrame(std::vector<uchar> &buffer);
    int findPointRegion(ParkingSpaceInfo &prakArea);
    int determineArea(ParkingSpaceInfo &prakArea);
signals:
    void callbackFrameReady(const cv::Mat &frame, const QString &url);

    void afterDownloadFile( int id,int recognitionType,QString ossUrl);

private slots:
    void sdkRealTimeDevSnapSyn(int hDevice);
    void pushRecordToCloud(int id,int recognitionType,QString ossUrl);
    //void releaseSemaphore();

private :
    int hDevice;
    int channel;
    QString httpUrl;

    SXSDKLoginParam *loginParam;
    SXMediaFaceImageReq *sxMediaFaceImageReq;

    std::mutex plateMutex;

    std::mutex faceMutex;
    QString sSn;
    QString url;
    std::map<int, vides_data::responseRecognitionData> videoCurrentData;

    std::map<QString, QString> currentData;

    //每个区域编号对应一个区域信息
    std::map<int,ParkingSpaceInfo*>parkMap;
    //当前相机监视所以车位区域
    std::vector<ParkingSpaceInfo*>parkingSpaceInfos;
    //当前人脸数
    int currentFace;

    int mediaHandle;
    //2秒钟抓一次图
    QTimer *dev_snap_syn_timer;

    int offlineCount=0;

    TCV_HumanDetector *detector;

    P_HLPR_Context ctx ;

    QSemaphore semaphore;

    int timeoutMs;

    int image_save;
    std::atomic<uint64> faceCount;

    uint64 face_frequency;


};
#endif // CAMERAHANDLE_H
