#include "CameraRealThread.h"
#include <QDebug>
#include <QProcess>

extern "C" {
#include <libavformat/avformat.h>
#include <libavcodec/avcodec.h>
#include <libavutil/avutil.h>
#include <libavutil/imgutils.h>
#include <libswscale/swscale.h>
}

CameraRealThread::CameraRealThread(const QString& rtspUrl, const QString& rtmpUrl) : m_rtspUrl(rtspUrl), m_rtmpUrl(rtmpUrl) {
    avformat_network_init();
}
CameraRealThread::~CameraRealThread(){
    // avformat_network_deinit();
}

void CameraRealThread::run(){
    

    // 打开 RTSP 流
    QByteArray rtByteArray = m_rtspUrl.toUtf8();
    const char* rt_url = rtByteArray.data();

    QByteArray rmByteArray = m_rtmpUrl.toUtf8();
    const char* rm_url ="flv://rtmp://push.sydip.com/live/44ad6edc63896566?auth_key=1707189971-0-0-dbac3b3c1f29652323355096908b2a62" ;//rmByteArray.data();


    qDebug() << "rm_url"<<rm_url;

    QProcess process;
    process.start("ffmpeg -formats | grep flv");
    process.waitForFinished();

    // 读取ffmpeg命令的输出结果
    QString output = process.readAllStandardOutput();

    // 检查输出结果中是否包含FLV格式信息
    if (output.contains("FLV (Flash Video)")) {
        qDebug() << "FFmpeg支持FLV格式";
    } else {
        qDebug() << "FFmpeg不支持FLV格式";
    }
    avformat_network_init();

    // 输入（RTSP）和输出（RTMP）的URL

    AVFormatContext *input_ctx = nullptr;
    AVFormatContext *output_ctx = nullptr;
    int ret;

    // 打开输入流
    if ((ret = avformat_open_input(&input_ctx, rt_url, nullptr, nullptr)) < 0) {
        return ;
    }

    if ((ret = avformat_find_stream_info(input_ctx, nullptr)) < 0) {
        return ;
    }
    char filename[64] = "test.ts";

    // 打开输出流
    avformat_alloc_output_context2(&output_ctx, nullptr, "mpegts", filename); // FLV格式用于RTMP
    if (!output_ctx) {
        qDebug()<< "Cannot create output context";
        return;
    }

    // 从输入流复制流信息到输出流
    for (int i = 0; i < input_ctx->nb_streams; i++) {
        AVStream *in_stream = input_ctx->streams[i];
        AVStream *out_stream = avformat_new_stream(output_ctx, nullptr);
        if (!out_stream) {
            return ;
        }
        avcodec_parameters_copy(out_stream->codecpar, in_stream->codecpar);
        out_stream->codecpar->codec_tag = 0;
    }

    // 打开输出URL
    if (!(output_ctx->oformat->flags & AVFMT_NOFILE)) {
        if (avio_open(&output_ctx->pb, rm_url, AVIO_FLAG_WRITE) < 0) {
            return ;
        }
    }

    // 写输出流的头部信息
    if (avformat_write_header(output_ctx, nullptr) < 0) {
        return ;
    }

    // 主循环，从输入读取数据并写入输出
    AVPacket pkt;
    while (true) {
        AVStream *in_stream, *out_stream;

        // 获取一个数据包
        if (av_read_frame(input_ctx, &pkt) < 0)
            break;

        in_stream  = input_ctx->streams[pkt.stream_index];
        out_stream = output_ctx->streams[pkt.stream_index];

        // 复制数据包
        pkt.pts = av_rescale_q_rnd(pkt.pts, in_stream->time_base, out_stream->time_base, (AVRounding)(AV_ROUND_NEAR_INF|AV_ROUND_PASS_MINMAX));
        pkt.dts = pkt.pts;
        pkt.duration = av_rescale_q(pkt.duration, in_stream->time_base, out_stream->time_base);
        pkt.pos = -1;

        // 写数据包到输出
        if (av_interleaved_write_frame(output_ctx, &pkt) < 0) {
            break;
        }
        av_packet_unref(&pkt);
    }

    // 写输出流的尾部信息
    av_write_trailer(output_ctx);

    // 关闭输入和输出
    avformat_close_input(&input_ctx);
    if (output_ctx && !(output_ctx->oformat->flags & AVFMT_NOFILE))
        avio_closep(&output_ctx->pb);
    avformat_free_context(output_ctx);

    avformat_network_deinit();
}
