#ifndef  FACERECOGNITION_H
#define FACERECOGNITION_H
#include "hyperface.h"
#include <opencv2/opencv.hpp>
#include<QCoreApplication>
#include "herror.h"
#include "LogHandle.h"
#include "VidesData.h"

class FaceReconition
{
private:
    static FaceReconition* instance;
    
    HContextHandle ctxHandle=nullptr;
    
    float configConfidence;
        
    std::vector<int32_t>customIds;

    FaceReconition();
    ~FaceReconition();
    
    
public:
    static FaceReconition& getInstance()
    {
        static FaceReconition instance;
        return instance;
    }
    
    void doesItExistEmployee(const cv::Mat &source,std::list<vides_data::faceRecognitionResult>&face);
        
    void initSourceImageMap(std::map<QString,QString>&maps,float confidence);
        
    int featureRemove();
    
};

#endif // FACERECOGNITION_H
