#ifndef HTTPSERVICE_H
#define HTTPSERVICE_H
#include "LogHandle.h"
#include "HttpClient.h"
#include "VidesData.h"
#include "Common.h"
#include <list>
#include <QJsonObject>
#include <QJsonArray>
#include <QJsonDocument>
#include <QUrlQuery>
#include <QMutex>
#include <QMutexLocker>
const QString OPERATION_FAILED="操作失败";
const QString OPERATION_SUCCESS="操作成功";
class HttpService{

public:
    HttpService();

    HttpService(QString httpUrl);
    //单次出⻔成功上报接⼝
    vides_data::response* httpPostDeviceStatus(vides_data::requestDeviceStatus & deviceStatus);

    vides_data::response* httpPostRecord(int id,int recongnition_type,QString sn,QString videw_addr);

    vides_data::response *httpFindCameras(QString &serialNumber,vides_data::responseDeviceData&datas);
    //车牌识别结果推送
    vides_data::response *httpLicensePlateRecognition(vides_data::requestLicensePlate &licensePlateRecognition,
                                                     std::list<vides_data::responseRecognitionData>&result
                                                      );
    //人脸列表
    vides_data::response *httpFindFaceReconition(QString &serialNumber,std::list<vides_data::responseFaceReconition*>&datas);
    //人脸识别推送
    vides_data::response *httpPostFaceReconition(vides_data::requestFaceReconition & faceReconition);
    //人数变化推送
    vides_data::response *httpPostFacePopulation(QByteArray &img,int &number,QString sn,qint64 time);

    //客户端组列表
    vides_data::response *httpFindStream(QString &serialNumber);

    vides_data::response *httpFindGb28181Config(QString &serialNumber);
    
    vides_data::response *httpDownload( const QString &filePath,QString &fullPathName);

    vides_data::response *httpUploadFile(const QString &filePath,QString& accessKeyId,QString& accessKeySecret,
                                         QString & bucketName,QString &securityToken);
    void setHttpUrl(const QString & httpUrl);

    static vides_data::responseStsCredentials stsCredentials;

    ~HttpService();
private:
    QString httpUrl;

    HttpClient m_httpClient;
    QMutex m_httpClientMutex;
    
};
#endif // HTTPSERVICE_H
