#include "HumanDetection.h"
HumanDetection* HumanDetection::instance = nullptr;

HumanDetection::HumanDetection(){
    
}
HumanDetection::~HumanDetection(){
}
int HumanDetection::findHuManCar(const cv::Mat &source,int res,TCV_HumanDetector *detector){
    TCV_CameraStream *stream = TCV_CreateCameraStream();
    TCV_CameraStreamSetData(stream, source.data, source.cols, source.rows);
    TCV_CameraStreamSetRotationMode(stream, TCV_CAMERA_ROTATION_0);
    TCV_CameraStreamSetStreamFormat(stream, TCV_STREAM_BGR);
    //0是人 1是车

    // 执行一帧目标检测
    TCV_HumanDetectorProcessFrame(detector, stream);
    int num = (res == 0) ? TCV_HumanDetectorGetNumOfHuman(detector) :TCV_HumanDetectorGetNumOfCar(detector);
    qDebug() << (res == 0 ? "Number of people detected:" : "Number of cars detected:") << num;
    TCV_ReleaseCameraStream(stream);

    return  num;
}

