#ifndef LICENSEPLATERECOGNITION_H
#define LICENSEPLATERECOGNITION_H
#include "hyper_lpr_sdk.h"
#include "LogHandle.h"
#include "VidesData.h"
#include <QString>
#include <opencv2/opencv.hpp>
#include <QTextStream>
#include <QFile>
#include <QImage>
#include <mutex>

const std::vector<std::string> types =
{"蓝牌", "黄牌单层", "白牌单层", "绿牌新能源", "黑牌港澳",
 "香港单层", "香港双层", "澳门单层", "澳门双层", "黄牌双层"};
class LicensePlateRecognition{
public:
    static LicensePlateRecognition& getInstance()
    {
        static LicensePlateRecognition instance;
        return instance;
    }
    //识别车牌号
    void licensePlateNumber(const cv::Mat &source,QString & lpNumber, vides_data::requestLicensePlate &plate,
                            qint64 currentTime,P_HLPR_Context ctx);
    
    void oldLicensePlateNumber(const cv::Mat &source,const QString &modelPaths,QString & lpNumber);
    
   // void initHlprContext(const QString &modelPaths,const QString &carCascade,float carConfidence);
   
    
private:
    static LicensePlateRecognition* instance;
    
    //P_HLPR_Context ctx ;
   
    float carConfidence;

    std::mutex carMutex;

    
    LicensePlateRecognition();
    
    ~LicensePlateRecognition();
    
    
};


#endif // LICENSEPLATERECOGNITION_H
