#ifndef PARKINGSPACEINFO_H
#define PARKINGSPACEINFO_H
#include "VidesData.h"
#include "RecognitionInfo.h"
#include <QMutex>
#include <QQueue>
class ParkingSpaceInfo {
public:
    ParkingSpaceInfo(RecognizedInfo & currentPlate);
    ParkingSpaceInfo();
    ~ParkingSpaceInfo();
    RecognizedInfo& getCurrentPlate();
    void setCurrentPlate(RecognizedInfo & current);
    void addQueue(RecognizedInfo &info);
    void removeQueue();
    void removeNoQueue();
    QQueue<RecognizedInfo> &getQueue();
    void setArea(vides_data::ParkingArea &a);
    vides_data::ParkingArea &getArea();

    int getSpaceIndex();
    void setSpaceIndex(int spaceIndex);
    
    
private:
    QQueue<RecognizedInfo> queuels;
    
    RecognizedInfo currentPlate;
    
    vides_data::ParkingArea area;
    
    int spaceIndex;

    QMutex queueMutex;

};

#endif // PARKINGSPACEINFO_H
