#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "Common.h"
#include "FaceRecognition.h"
#include "LicensePlateRecognition.h"
#include "hyper_lpr_sdk.h"
#include "CameraHandle.h"
#include "HttpService.h"
#include "VidesData.h"
#include "MediaFaceImage.h"
#include "HumanDetection.h"
#include <algorithm>
#include <QString>
#include <QTextCodec>
#include <QObject>
#include <QByteArray>
#include <QSettings>
#include <QTimer>
#include <QSemaphore>
#include <QDebug>
#include <QResource>
#include <opencv2/opencv.hpp>
#include <QRandomGenerator>
#include <QTcpServer>
#include <QTcpSocket>
//namespace Ui { class MainWindow; }


class MainWindow : public QObject
{
    Q_OBJECT
    
public:
    explicit MainWindow();
    
    void initCommon();
    
    void setVideoPath(int flag, const QString& path);
    
    void createDirectory(int flag,const QString& dirName, const QString& successMsg, const QString& failureMsg);
    

    void initFaceFaceRecognition();
    
    void initCameras(vides_data::cameraParameters &parameter,const std::list<vides_data::responseArea>&areas);
    
    static MainWindow * sp_this;



    void sendJsonResponse(QTcpSocket* socket, int code, const QString& data, const QString& msg);
    void sendEmptyResponse(QTcpSocket* socket);
    void sendNotFoundResponse(QTcpSocket* socket);

    void updateLocalFace(const QString &httpurl);

    void removeImageFiles(QString id);
    
    void modifyImagesAndNames(QString &modId);

    void findLocalSerialNumber(QString &serialNumber);
    
    void initDevConfigSyn(CameraHandle *cameraHandle);

    void iniRecordingToString(QString &recorJson);

    void iniEncodeToString(QString &enCodeJson);

    void clearOfflineCameraHandle(QString sDevId, int nDevPort);

    bool iniWorkSpVMn(vides_data::responseGb28181 *gb28181,QString &workSpWMn,QString &sn);

    bool isDeviceInList(const QString& deviceId, const  std::list<vides_data::responseDeviceStatus>& devices);
    // 过滤函数
    void deleteCloudNotCamer (const std::map<QString,vides_data::localDeviceStatus*>& localDevices,
                              const std::list<vides_data::responseDeviceStatus>& devices);
    
    ~MainWindow();
signals:
    void shutdownSignals(QString sDevId, int nDevPort);
    
private slots:
    void startCamera(const QString &httpurl);
    
    void deleteLogFile();

    void clearHandle(QString sDevId, int nDevPort);

    void deleteMkvFileTimer();
    
    void handleMatNewConnection();
private:
    //Ui::MainWindow *ui;
    
    QSettings *qSetting;
    
    QTimer *deleteLogFileTimer;
    
    QTimer *deleteFrameFileTimer;

    QTimer*dePermissionSynTimer;

    QTcpServer server;

    
    //本地id:图片路径
    std::map<QString,QString>localImageMap;
    //云端id:oss路径
    std::map<QString,QString>cloudImageMap;
    
    QString modelPaths;
    
    std::map<QString,CameraHandle*>faceDetectionParkingPushs;
};
#endif // MAINWINDOW_H
