#ifndef HUMANDETECTION_H
#define HUMANDETECTION_H
#include "VidesData.h"
#include "so_human_sdk.h"
#include "ScopeSemaphoreExit.h"
#include "BaseAlgorithm.h"
#include <signal.h>
#include <QDateTime>
#include <opencv2/opencv.hpp>
#include <QDebug>
#include <atomic>
#include<QThread>
class HumanDetection:public BaseAlgorithm {
public:
    HumanDetection(const QString &modelPaths,
                   float carShapeConfidence);
    ~HumanDetection();
    
    int findHuManCar(const cv::Mat &source,int res,std::map<int,int>&reMap,QString &sSn,
                     float &heightReference,  std::vector<vides_data::ParkingArea> &currentPlate);
    
    void setHuManParameter(QString &uniformColor);
    
    void draw_human_on_image(const cv::Mat& image, const TCV_ObjectLocation* boxes, int size);

private:
    //高度基准
    float heightReference;
    
    QString uniformColor;
    
    TCV_HumanDetector *detector;

};

#endif // HUMANDETECTION_H
