#ifndef TASKRUNNABLE_H
#define TASKRUNNABLE_H

#include <QMutex>
#include <QMutexLocker>
#include <QRunnable>
#include <QString>
#include <functional>
#include <QDebug>
enum RunFunction {
    SdkDevSnapSyn,
    SdkCallbackFunction
};

class TaskRunnable : public QRunnable {
public:
    typedef std::function<void()> DevSnapSyn;
    typedef std::function<void()> CallbackFunction;
    ~TaskRunnable();
    TaskRunnable(std::function<void()> newTask, int hDevice, int channel, RunFunction function);
    void setString(const QString& str);
    void setHdevice(const int& hDevice);
    void setChannel(const int& channel);
    void setRunFunction(RunFunction func);
    void setDevSnapSyn(const DevSnapSyn& function);
    
    void setCallbackFunction(const CallbackFunction& function);
    void run() override;
    
private:
    DevSnapSyn devSnapSyn;
    CallbackFunction callbackFunction;
    int m_hDevice;
    int m_channel;
    QString szString;
    RunFunction runFunction;
    QMutex mutex;
};

#endif // TASKRUNNABLE_H
