#include "ParkingSpaceInfo.h"

ParkingSpaceInfo::ParkingSpaceInfo(RecognizedInfo &currentPlate)
    :currentPlate(currentPlate)
{
    
}
ParkingSpaceInfo::ParkingSpaceInfo(){
    
}
ParkingSpaceInfo::~ParkingSpaceInfo(){
    qInfo() <<  "ParkingSpaceInfo:关闭";

}
void ParkingSpaceInfo::addQueue(RecognizedInfo &info){
    QMutexLocker locker(&queueMutex);
    queuels.enqueue(info);
}
void ParkingSpaceInfo::removeQueue(){
    QMutexLocker locker(&queueMutex);
    if (!queuels.isEmpty()) {
        queuels.dequeue();
    }
}

void ParkingSpaceInfo::removeNoQueue() {
    QMutexLocker locker(&queueMutex);
    if (!queuels.isEmpty() && queuels.size() > 3) {
        // 逆向遍历，这样在移除元素时不会影响还未遍历到的元素的索引
        for (int i = queuels.size() - 1; i >= 0; --i) {
            if (queuels[i].getLicensePlate().isEmpty()) {
                queuels.removeAt(i);
            }
        }
    }
}
QQueue<RecognizedInfo> &ParkingSpaceInfo::getQueue(){
    return queuels;
}

void ParkingSpaceInfo::setArea(vides_data::ParkingArea &a){
    QMutexLocker locker(&queueMutex);
    this->area=a;
}
vides_data::ParkingArea& ParkingSpaceInfo::getArea(){
    return area;
}

RecognizedInfo& ParkingSpaceInfo::getCurrentPlate(){
    return currentPlate;
}
void ParkingSpaceInfo::setCurrentPlate(RecognizedInfo &current){
    QMutexLocker locker(&queueMutex);
    this->currentPlate=current;
}
int ParkingSpaceInfo::getSpaceIndex(){
    return spaceIndex;
}
void ParkingSpaceInfo::setSpaceIndex(int spaceIndex){
    QMutexLocker locker(&queueMutex);
    this->spaceIndex=spaceIndex;
}
