#ifndef NONCONNECTEDCAMERAHANDLE_H
#define NONCONNECTEDCAMERAHANDLE_H

#include "XSDKPublic.h"
#include "XNetSDKSyn.h"
#include "XNetSDKDefine.h"
#include "VidesData.h"
#include "Common.h"
#include "ScopeSemaphoreExit.h"
#include "Json_Header/NetWork_NetCommon.h"
#include "Json_Header/NetWork_Wifi.h"
#include <arpa/inet.h>
class NonConnectedCameraHandle
{
public:
    static NonConnectedCameraHandle* getInstance();  // 单例模式获取实例的静态成员函数


    //有线修改相机ip
    bool changeCameraIp(vides_data::localDevice &device);
    //无线修改相机ip
    bool wifiChangeIp(QString &Ip,int h_device,QString &sn);

    bool isWifiConnect(XSDK_HANDLE hDevice,XSDK_CFG::NetWork_Wifi &cfg);

    void printWifi(XSDK_HANDLE hDevice,XSDK_CFG::NetWork_Wifi &cfg);

    bool distributionNetwork(QString &ip,QString &sSn,int hDevice);


    int sdkDevLoginSyn(QString sDevId, int nDevPort,
                                     QString sUserName, QString sPassword, int nTimeout) ;

private:
    NonConnectedCameraHandle();  // 构造函数声明为私有
    ~NonConnectedCameraHandle();  // 析构函数声明为私有

    static NonConnectedCameraHandle* m_instance;  // 指向实例的指针
};


#endif // NONCONNECTEDCAMERAHANDLE_H
