#include "Common.h"

Common::Common(){}

QString Common::getTimeString() {
    QDateTime currentDateTime = QDateTime::currentDateTime();
    QString formattedDateTime = currentDateTime.toString("yyyy-MM-dd hh:mm:ss");
    return formattedDateTime;
}
QString Common::timestampToDateString(qint64 timestamp) {
    QDateTime dateTime = QDateTime::fromSecsSinceEpoch(timestamp);
    QString formattedDate = dateTime.toString("yyyy-MM-dd hh:mm:ss");
    return formattedDate;
}
QString Common::generateSignature(const QString& accessKeySecret, const QString& verb,
                                  const QString& contentMD5, const QString& contentType,
                                  const QString& date, const QString& ossHeaders,
                                  const QString& canonicalizedResource)
{
    // 构造规范化的字符串
    QString stringToSign = verb + "\n" +
            contentMD5 + "\n" +
            contentType + "\n" +
            date + "\n" +
            ossHeaders+ "\n" +  // 添加'\n'分隔符，并确保ossHeaders末尾没有多余的空白
            canonicalizedResource;
    
    // 将密钥和消息转换为字节数组
    QByteArray hmacKey = accessKeySecret.toUtf8();
    QByteArray message = stringToSign.toUtf8();
    // 使用HMAC-SHA1计算签名
    QMessageAuthenticationCode mac(QCryptographicHash::Sha1);
    mac.setKey(hmacKey);
    mac.addData(message);
    
    
    QByteArray signature = mac.result().toBase64();  // 直接使用QMessageAuthenticationCode的结果
    
    return QString(signature);
}
QString Common::getVideoOut(){
    return videoOut;
}
void Common::setVideoOut(QString videoOut){
    videoOut.append("/");
    this->videoOut=videoOut;
}


QString Common::getVideoDownload(){
    return videoDownload;
}
void Common::setVideoDownload(QString videoDownload){
    videoDownload.append("/");
    this->videoDownload=videoDownload;
}

QString Common::getImages(){
    return images;
}
void Common::setImages(QString images){
    images.append("/");
    this->images=images;
}

QString Common::DecIpToHexIp(const QString& decIp) {
    // 将 IP 地址按点号分割成多个部分
    QStringList parts = decIp.split(".");

    // 检查 IP 地址是否有效（应包含 4 个部分）
    if (parts.size() != 4) {
        return QString(); // 如果无效，返回空字符串
    }

    QString hexIp; // 用于存储最终的十六进制表示

    // 从最后一个部分开始遍历
    for (int i = 3; i >= 0; --i) {
        // 将每个部分转换为整数
        bool ok;
        int part = parts[i].toInt(&ok);
        if (!ok) return QString(); // 如果转换失败，返回空字符串

        // 将整数转换为十六进制字符串，并在必要时补零
        QString hexPart = QString::number(part, 16).rightJustified(2, '0');

        // 将十六进制字符串添加到结果中
        hexIp.append(hexPart);
    }

    // 在结果前添加 "0x" 以表示十六进制
    hexIp.prepend("0x");

    return hexIp; // 返回最终的十六进制表示
}
QString Common::GetLocalIp() {
    QString ipAddress;
    QList<QHostAddress> list = QNetworkInterface::allAddresses();
    for (const QHostAddress& address : list) {
        if (address != QHostAddress::LocalHost && address.toIPv4Address()) {
            ipAddress = address.toString();
            break;
        }
    }
    if (ipAddress.isEmpty()) {
        ipAddress = QHostAddress(QHostAddress::LocalHost).toString();
    }
    return ipAddress;
}
Common::~Common(){}
